"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.copyResponse = copyResponse;
const clone_1 = require("../clone");
// Copying will help to avoid circular structure
// and mutation of the cached response.
function copyResponse(response, deep) {
    const { body, statusCode, headers } = response;
    return deep
        ? {
            statusCode,
            body: body instanceof Buffer ? body.subarray() : (0, clone_1.clone)(body),
            headers: (0, clone_1.clone)(headers),
        }
        : {
            statusCode,
            body,
            headers,
        };
}
//# sourceMappingURL=util.js.map