"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Throttle = void 0;
exports.getThrottle = getThrottle;
exports.clear = clear;
const tslib_1 = require("tslib");
const p_throttle_1 = tslib_1.__importDefault(require("p-throttle"));
const logger_1 = require("../../logger");
const url_1 = require("../url");
const rate_limits_1 = require("./rate-limits");
const hostThrottles = new Map();
class Throttle {
    throttle;
    constructor(interval) {
        this.throttle = (0, p_throttle_1.default)({
            strict: true,
            limit: 1,
            interval,
        });
    }
    add(task) {
        const throttledTask = this.throttle(task);
        return throttledTask();
    }
}
exports.Throttle = Throttle;
function getThrottle(url) {
    const host = (0, url_1.parseUrl)(url)?.host;
    if (!host) {
        // should never happen
        logger_1.logger.debug(`No host on ${url}`);
        return null;
    }
    let throttle = hostThrottles.get(host);
    if (throttle === undefined) {
        throttle = null; // null represents "no throttle", as opposed to undefined
        const throttleMs = (0, rate_limits_1.getThrottleIntervalMs)(url);
        if (throttleMs) {
            logger_1.logger.debug(`Using throttle ${throttleMs} intervalMs for host ${host}`);
            throttle = new Throttle(throttleMs);
        }
        else {
            logger_1.logger.trace({ host }, 'No throttle');
        }
    }
    hostThrottles.set(host, throttle);
    return throttle;
}
function clear() {
    hostThrottles.clear();
}
//# sourceMappingURL=throttle.js.map