"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RequestError = void 0;
exports.fetch = fetch;
exports.stream = stream;
const tslib_1 = require("tslib");
// TODO: refactor code to remove this (#9651)
require("./legacy");
const got_1 = tslib_1.__importStar(require("got"));
const logger_1 = require("../../logger");
const number_1 = require("../number");
const stats_1 = require("../stats");
const string_1 = require("../string");
const hooks_1 = require("./hooks");
var got_2 = require("got");
Object.defineProperty(exports, "RequestError", { enumerable: true, get: function () { return got_2.RequestError; } });
async function fetch(url, options, queueStats) {
    logger_1.logger.trace({ url, options }, 'got request');
    let duration = 0;
    let statusCode = 0;
    try {
        // Cheat the TS compiler using `as` to pick a specific overload.
        // Otherwise it doesn't typecheck.
        const resp = await (0, got_1.default)(url, { ...options, hooks: hooks_1.hooks });
        statusCode = resp.statusCode;
        duration = (0, number_1.coerceNumber)(resp.timings.phases.total, 0);
        return resp;
    }
    catch (error) {
        if (error instanceof got_1.RequestError) {
            statusCode = (0, number_1.coerceNumber)(error.response?.statusCode, -1);
            duration = (0, number_1.coerceNumber)(error.timings?.phases.total, -1);
            const method = options.method.toUpperCase();
            const code = (0, string_1.coerceString)(error.code, 'UNKNOWN');
            const retryCount = (0, number_1.coerceNumber)(error.request?.retryCount, -1);
            logger_1.logger.debug(`${method} ${url} = (code=${code}, statusCode=${statusCode} retryCount=${retryCount}, duration=${duration})`);
        }
        throw error;
        /* v8 ignore next: 🐛 https://github.com/bcoe/c8/issues/229 */
    }
    finally {
        stats_1.HttpStats.write({
            method: options.method,
            url,
            reqMs: duration,
            queueMs: queueStats.queueMs,
            status: statusCode,
        });
    }
}
function stream(url, options) {
    return got_1.default.stream(url, options);
}
//# sourceMappingURL=got.js.map