import { type RetryObject } from 'got';
import { HttpBase, type InternalJsonUnsafeOptions } from './http';
import type { HttpMethod, HttpOptions, HttpResponse } from './types';
export declare const setBaseUrl: (url: string) => void;
export interface GitlabHttpOptions extends HttpOptions {
    paginate?: boolean;
}
export declare class GitlabHttp extends HttpBase<GitlabHttpOptions> {
    protected get baseUrl(): string | undefined;
    constructor(type?: string, options?: GitlabHttpOptions);
    protected requestJsonUnsafe<T = unknown>(method: HttpMethod, options: InternalJsonUnsafeOptions<GitlabHttpOptions>): Promise<HttpResponse<T>>;
    protected handleError(url: string | URL, _httpOptions: HttpOptions, err: Error): never;
    protected calculateRetryDelay(retryObject: RetryObject): number;
}
