"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GiteaHttp = exports.setBaseUrl = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const http_1 = require("./http");
let baseUrl;
const setBaseUrl = (newBaseUrl) => {
    baseUrl = newBaseUrl.replace(/\/*$/, '/'); // TODO #12875
};
exports.setBaseUrl = setBaseUrl;
function getPaginationContainer(body) {
    if (is_1.default.array(body) && body.length) {
        return body;
    }
    if (is_1.default.plainObject(body) && is_1.default.array(body?.data) && body.data.length) {
        return body.data;
    }
    return null;
}
class GiteaHttp extends http_1.HttpBase {
    get baseUrl() {
        return baseUrl;
    }
    constructor(hostType, options) {
        super(hostType ?? 'gitea', options);
    }
    async requestJsonUnsafe(method, options) {
        const resolvedUrl = this.resolveUrl(options.url, options.httpOptions);
        const opts = {
            ...options,
            url: resolvedUrl,
        };
        const res = await super.requestJsonUnsafe(method, opts);
        const pc = getPaginationContainer(res.body);
        if (opts.httpOptions?.paginate && pc) {
            delete opts.httpOptions.cacheProvider;
            opts.httpOptions.memCache = false;
            delete opts.httpOptions.paginate;
            const total = parseInt(res.headers['x-total-count'], 10);
            let nextPage = parseInt(resolvedUrl.searchParams.get('page') ?? '1', 10);
            while (total && pc.length < total) {
                nextPage += 1;
                resolvedUrl.searchParams.set('page', nextPage.toString());
                const nextRes = await super.requestJsonUnsafe(method, opts);
                const nextPc = getPaginationContainer(nextRes.body);
                if (nextPc === null) {
                    break;
                }
                pc.push(...nextPc);
            }
        }
        return res;
    }
}
exports.GiteaHttp = GiteaHttp;
//# sourceMappingURL=gitea.js.map