import { HttpBase, type InternalJsonUnsafeOptions } from './http';
import type { HttpMethod, HttpOptions, HttpResponse } from './types';
export declare const setBaseUrl: (newBaseUrl: string) => void;
export interface GiteaHttpOptions extends HttpOptions {
    paginate?: boolean;
}
export declare class GiteaHttp extends HttpBase<GiteaHttpOptions> {
    protected get baseUrl(): string | undefined;
    constructor(hostType?: string, options?: HttpOptions);
    protected requestJsonUnsafe<T = unknown>(method: HttpMethod, options: InternalJsonUnsafeOptions<GiteaHttpOptions>): Promise<HttpResponse<T>>;
}
