import { HttpBase, type InternalHttpOptions } from './http';
import type { HttpOptions } from './types';
export declare function setBaseUrl(url: string): void;
/**
 * Access Gerrit REST-API and strip-of the "magic prefix" from responses.
 * @see https://gerrit-review.googlesource.com/Documentation/rest-api.html
 */
export declare class GerritHttp extends HttpBase {
    private static magicPrefix;
    protected get baseUrl(): string | undefined;
    constructor(options?: HttpOptions);
    protected resolveUrl(requestUrl: string | URL, options: HttpOptions | undefined): URL;
    protected processOptions(url: URL, options: InternalHttpOptions): void;
}
