"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.repoCacheProvider = exports.RepositoryHttpCacheProvider = void 0;
const repository_1 = require("../../cache/repository");
const abstract_http_cache_provider_1 = require("./abstract-http-cache-provider");
class RepositoryHttpCacheProvider extends abstract_http_cache_provider_1.AbstractHttpCacheProvider {
    load(url) {
        const cache = (0, repository_1.getCache)();
        cache.httpCache ??= {};
        return Promise.resolve(cache.httpCache[url]);
    }
    persist(url, data) {
        const cache = (0, repository_1.getCache)();
        cache.httpCache ??= {};
        cache.httpCache[url] = data;
        return Promise.resolve();
    }
}
exports.RepositoryHttpCacheProvider = RepositoryHttpCacheProvider;
exports.repoCacheProvider = new RepositoryHttpCacheProvider();
//# sourceMappingURL=repository-http-cache-provider.js.map