import type { GotOptions, HttpResponse } from '../types';
import { type HttpCache } from './schema';
import type { HttpCacheProvider } from './types';
export declare abstract class AbstractHttpCacheProvider implements HttpCacheProvider {
    protected abstract load(url: string): Promise<unknown>;
    protected abstract persist(url: string, data: HttpCache): Promise<void>;
    get(url: string): Promise<HttpCache | null>;
    setCacheHeaders<T extends Pick<GotOptions, 'headers'>>(url: string, opts: T): Promise<void>;
    bypassServer<T>(_url: string, _ignoreSoftTtl: boolean): Promise<HttpResponse<T> | null>;
    wrapServerResponse<T>(url: string, resp: HttpResponse<T>): Promise<HttpResponse<T>>;
}
