"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BitbucketHttp = void 0;
exports.setBaseUrl = setBaseUrl;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const http_1 = require("./http");
const MAX_PAGES = 100;
const MAX_PAGELEN = 100;
let baseUrl = 'https://api.bitbucket.org/';
function setBaseUrl(url) {
    baseUrl = url;
}
class BitbucketHttp extends http_1.HttpBase {
    get baseUrl() {
        return baseUrl;
    }
    constructor(type = 'bitbucket', options) {
        super(type, options);
    }
    async requestJsonUnsafe(method, options) {
        const resolvedUrl = this.resolveUrl(options.url, options.httpOptions);
        const opts = {
            ...options,
            url: resolvedUrl,
        };
        const paginate = opts.httpOptions?.paginate;
        if (paginate && !hasPagelen(resolvedUrl)) {
            const pagelen = opts.httpOptions.pagelen ?? MAX_PAGELEN;
            resolvedUrl.searchParams.set('pagelen', pagelen.toString());
        }
        const result = await super.requestJsonUnsafe(method, opts);
        if (paginate && isPagedResult(result.body)) {
            if (opts.httpOptions) {
                delete opts.httpOptions.cacheProvider;
                opts.httpOptions.memCache = false;
            }
            const resultBody = result.body;
            let nextURL = result.body.next;
            let page = 1;
            for (; nextURL && page <= MAX_PAGES; page++) {
                opts.url = nextURL;
                const nextResult = await super.requestJsonUnsafe(method, opts);
                resultBody.values.push(...nextResult.body.values);
                nextURL = nextResult.body.next;
            }
            // Override other page-related attributes
            resultBody.pagelen = resultBody.values.length;
            /* v8 ignore start -- hard to test all branches */
            resultBody.size =
                page <= MAX_PAGES ? resultBody.values.length : undefined;
            resultBody.next = page <= MAX_PAGES ? nextURL : undefined;
            /* v8 ignore stop */
        }
        return result;
    }
}
exports.BitbucketHttp = BitbucketHttp;
function hasPagelen(url) {
    return !is_1.default.nullOrUndefined(url.searchParams.get('pagelen'));
}
function isPagedResult(obj) {
    return is_1.default.nonEmptyObject(obj) && Array.isArray(obj.values);
}
//# sourceMappingURL=bitbucket.js.map