"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BitbucketServerHttp = exports.setBaseUrl = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const http_1 = require("./http");
const MAX_LIMIT = 100;
const MAX_PAGES = 100;
let baseUrl;
const setBaseUrl = (url) => {
    baseUrl = url;
};
exports.setBaseUrl = setBaseUrl;
class BitbucketServerHttp extends http_1.HttpBase {
    get baseUrl() {
        return baseUrl;
    }
    constructor(type = 'bitbucket-server', options) {
        super(type, options);
    }
    async requestJsonUnsafe(method, options) {
        const resolvedUrl = this.resolveUrl(options.url, options.httpOptions);
        const opts = { ...options, url: resolvedUrl };
        opts.httpOptions ??= {};
        opts.httpOptions.headers ??= {};
        opts.httpOptions.headers['X-Atlassian-Token'] = 'no-check';
        const paginate = opts.httpOptions.paginate;
        if (paginate) {
            const limit = opts.httpOptions.limit ?? MAX_LIMIT;
            resolvedUrl.searchParams.set('limit', limit.toString());
        }
        const result = await super.requestJsonUnsafe(method, opts);
        if (paginate && isPagedResult(result.body)) {
            if (opts.httpOptions) {
                delete opts.httpOptions.cacheProvider;
                opts.httpOptions.memCache = false;
            }
            const collectedValues = [...result.body.values];
            let nextPageStart = result.body.nextPageStart;
            let maxPages = opts.httpOptions.maxPages ?? MAX_PAGES;
            while (nextPageStart && --maxPages > 0) {
                resolvedUrl.searchParams.set('start', nextPageStart.toString());
                const nextResult = await super.requestJsonUnsafe(method, opts);
                collectedValues.push(...nextResult.body.values);
                nextPageStart = nextResult.body.nextPageStart;
            }
            return { ...result, body: collectedValues };
        }
        return result;
    }
}
exports.BitbucketServerHttp = BitbucketServerHttp;
function isPagedResult(obj) {
    return is_1.default.nonEmptyObject(obj) && is_1.default.array(obj.values);
}
//# sourceMappingURL=bitbucket-server.js.map