"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.prepareQuery = prepareQuery;
exports.isDateExpired = isDateExpired;
const luxon_1 = require("luxon");
function prepareQuery(payloadQuery) {
    return `
    query($owner: String!, $name: String!, $cursor: String, $count: Int!) {
      repository(owner: $owner, name: $name) {
        isRepoPrivate: isPrivate
        payload: ${payloadQuery}
      }
    }
  `;
}
/**
 * Tells whether the time `duration` is expired starting
 * from the `date` (ISO date format) at the moment of `now`.
 */
function isDateExpired(currentTime, initialTimestamp, duration) {
    const expiryTime = luxon_1.DateTime.fromISO(initialTimestamp).plus(duration).toUTC();
    return currentTime >= expiryTime;
}
//# sourceMappingURL=util.js.map