import { z } from 'zod';
import { Timestamp } from '../../../timestamp';
import type { GithubGraphqlDatasourceAdapter, GithubTagItem } from '../types';
declare const GithubGraphqlTag: z.ZodObject<{
    version: z.ZodString;
    target: z.ZodUnion<[z.ZodObject<{
        type: z.ZodLiteral<"Commit">;
        oid: z.ZodString;
        releaseTimestamp: z.ZodEffects<z.ZodUnknown, Timestamp, unknown>;
    }, "strip", z.ZodTypeAny, {
        type: "Commit";
        releaseTimestamp: string & {
            __timestamp: never;
        };
        oid: string;
    }, {
        type: "Commit";
        oid: string;
        releaseTimestamp?: unknown;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"Tag">;
        target: z.ZodUnion<[z.ZodObject<{
            type: z.ZodLiteral<"Commit">;
            oid: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            type: "Commit";
            oid: string;
        }, {
            type: "Commit";
            oid: string;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"Tag">;
            target: z.ZodObject<{
                oid: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                oid: string;
            }, {
                oid: string;
            }>;
        }, "strip", z.ZodTypeAny, {
            type: "Tag";
            target: {
                oid: string;
            };
        }, {
            type: "Tag";
            target: {
                oid: string;
            };
        }>]>;
        tagger: z.ZodObject<{
            releaseTimestamp: z.ZodEffects<z.ZodUnknown, Timestamp, unknown>;
        }, "strip", z.ZodTypeAny, {
            releaseTimestamp: string & {
                __timestamp: never;
            };
        }, {
            releaseTimestamp?: unknown;
        }>;
    }, "strip", z.ZodTypeAny, {
        type: "Tag";
        target: {
            type: "Commit";
            oid: string;
        } | {
            type: "Tag";
            target: {
                oid: string;
            };
        };
        tagger: {
            releaseTimestamp: string & {
                __timestamp: never;
            };
        };
    }, {
        type: "Tag";
        target: {
            type: "Commit";
            oid: string;
        } | {
            type: "Tag";
            target: {
                oid: string;
            };
        };
        tagger: {
            releaseTimestamp?: unknown;
        };
    }>]>;
}, "strip", z.ZodTypeAny, {
    version: string;
    target: {
        type: "Commit";
        releaseTimestamp: string & {
            __timestamp: never;
        };
        oid: string;
    } | {
        type: "Tag";
        target: {
            type: "Commit";
            oid: string;
        } | {
            type: "Tag";
            target: {
                oid: string;
            };
        };
        tagger: {
            releaseTimestamp: string & {
                __timestamp: never;
            };
        };
    };
}, {
    version: string;
    target: {
        type: "Commit";
        oid: string;
        releaseTimestamp?: unknown;
    } | {
        type: "Tag";
        target: {
            type: "Commit";
            oid: string;
        } | {
            type: "Tag";
            target: {
                oid: string;
            };
        };
        tagger: {
            releaseTimestamp?: unknown;
        };
    };
}>;
export type GithubGraphqlTag = z.infer<typeof GithubGraphqlTag>;
export declare const adapter: GithubGraphqlDatasourceAdapter<GithubGraphqlTag, GithubTagItem>;
export {};
