import { z } from 'zod';
import { Timestamp } from '../../../timestamp';
import type { GithubGraphqlDatasourceAdapter, GithubReleaseItem } from '../types';
declare const GithubGraphqlRelease: z.ZodObject<{
    version: z.ZodString;
    releaseTimestamp: z.ZodEffects<z.ZodUnknown, Timestamp, unknown>;
    isDraft: z.ZodBoolean;
    isPrerelease: z.ZodBoolean;
    url: z.ZodString;
    id: z.ZodNullable<z.ZodNumber>;
    name: z.ZodNullable<z.ZodString>;
    description: z.ZodNullable<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    id: number | null;
    url: string;
    name: string | null;
    description: string | null;
    version: string;
    releaseTimestamp: string & {
        __timestamp: never;
    };
    isDraft: boolean;
    isPrerelease: boolean;
}, {
    id: number | null;
    url: string;
    name: string | null;
    description: string | null;
    version: string;
    isDraft: boolean;
    isPrerelease: boolean;
    releaseTimestamp?: unknown;
}>;
export type GithubGraphqlRelease = z.infer<typeof GithubGraphqlRelease>;
export declare const adapter: GithubGraphqlDatasourceAdapter<GithubGraphqlRelease, GithubReleaseItem>;
export {};
