import type { GithubHttp } from '../../http/github';
import type { GithubDatasourceItem, GithubGraphqlDatasourceAdapter, GithubPackageConfig } from './types';
export declare class GithubGraphqlDatasourceFetcher<GraphqlItem, ResultItem extends GithubDatasourceItem> {
    private http;
    private datasourceAdapter;
    static query<T, U extends GithubDatasourceItem>(config: GithubPackageConfig, http: GithubHttp, adapter: GithubGraphqlDatasourceAdapter<T, U>): Promise<U[]>;
    private readonly baseUrl;
    private readonly repoOwner;
    private readonly repoName;
    private itemsPerQuery;
    private queryCount;
    private cursor;
    private isPersistent;
    constructor(packageConfig: GithubPackageConfig, http: GithubHttp, datasourceAdapter: GithubGraphqlDatasourceAdapter<GraphqlItem, ResultItem>);
    private getCacheNs;
    private getCacheKey;
    private getRawQueryOptions;
    private doRawQuery;
    private shrinkPageSize;
    private hasReachedQueryLimit;
    private doShrinkableQuery;
    private _cacheStrategy;
    private cacheStrategy;
    /**
     * This method is responsible for data synchronization.
     * It also detects persistence of the package, based on the first page result.
     */
    private doPaginatedFetch;
    private doCachedQuery;
    loadPersistenceFlag(): Promise<void>;
    storePersistenceFlag(minutes: number): Promise<void>;
    /**
     * This method ensures the only one query is executed
     * to a particular package during single run.
     */
    private doUniqueQuery;
    getItems(): Promise<ResultItem[]>;
}
