"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubGraphqlPackageCacheStrategy = void 0;
const tslib_1 = require("tslib");
const packageCache = tslib_1.__importStar(require("../../../cache/package"));
const abstract_cache_strategy_1 = require("./abstract-cache-strategy");
/**
 * Package cache strategy meant to be used for public packages.
 */
class GithubGraphqlPackageCacheStrategy extends abstract_cache_strategy_1.AbstractGithubGraphqlCacheStrategy {
    load() {
        return packageCache.get(this.cacheNs, this.cacheKey);
    }
    async persist(cacheRecord) {
        const expiry = this.createdAt
            .plus({
            // Not using 'days' as it does not handle adjustments for Daylight Saving time.
            // The offset in the resulting DateTime object does not match that of the expiry or this.now.
            hours: abstract_cache_strategy_1.AbstractGithubGraphqlCacheStrategy.cacheTTLDays * 24,
        })
            .toUTC();
        const ttlMinutes = expiry.diff(this.now, ['minutes']).as('minutes');
        if (ttlMinutes && ttlMinutes > 0) {
            await packageCache.set(this.cacheNs, this.cacheKey, cacheRecord, ttlMinutes);
        }
    }
}
exports.GithubGraphqlPackageCacheStrategy = GithubGraphqlPackageCacheStrategy;
//# sourceMappingURL=package-cache-strategy.js.map