import type { GithubDatasourceItem, GithubGraphqlCacheRecord } from '../types';
import { AbstractGithubGraphqlCacheStrategy } from './abstract-cache-strategy';
/**
 * Package cache strategy meant to be used for public packages.
 */
export declare class GithubGraphqlPackageCacheStrategy<GithubItem extends GithubDatasourceItem> extends AbstractGithubGraphqlCacheStrategy<GithubItem> {
    load(): Promise<GithubGraphqlCacheRecord<GithubItem> | undefined>;
    persist(cacheRecord: GithubGraphqlCacheRecord<GithubItem>): Promise<void>;
}
