"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCachedModifiedResult = getCachedModifiedResult;
exports.setCachedModifiedResult = setCachedModifiedResult;
const logger_1 = require("../../logger");
const repository_1 = require("../cache/repository");
function getCachedModifiedResult(branchName, branchSha) {
    const cache = (0, repository_1.getCache)();
    const branch = cache.branches?.find((branch) => branch.branchName === branchName);
    if (branch?.sha === branchSha && branch.isModified !== undefined) {
        return branch.isModified;
    }
    return null;
}
function setCachedModifiedResult(branchName, isModified) {
    const cache = (0, repository_1.getCache)();
    const branch = cache.branches?.find((branch) => branch.branchName === branchName);
    if (!branch) {
        logger_1.logger.debug(`setCachedModifiedResult(): Branch cache not present`);
        return;
    }
    branch.isModified = isModified;
}
//# sourceMappingURL=modified-cache.js.map