"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setNoVerify = setNoVerify;
exports.getNoVerify = getNoVerify;
exports.simpleGitConfig = simpleGitConfig;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const global_1 = require("../../config/global");
let noVerify = ['push', 'commit'];
function setNoVerify(value) {
    if (!is_1.default.array(value, is_1.default.string)) {
        throw new Error('config error: gitNoVerify should be an array of strings');
    }
    noVerify = value;
}
function getNoVerify() {
    return noVerify;
}
function simpleGitConfig() {
    const config = {
        completion: {
            onClose: true,
            onExit: false,
        },
        config: ['core.quotePath=false'],
    };
    // https://github.com/steveukx/git-js/pull/591
    const gitTimeout = global_1.GlobalConfig.get('gitTimeout');
    if (is_1.default.number(gitTimeout) && gitTimeout > 0) {
        config.timeout = { block: gitTimeout };
    }
    return config;
}
//# sourceMappingURL=config.js.map