"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ensureLocalPath = ensureLocalPath;
exports.ensureCachePath = ensureCachePath;
exports.isValidPath = isValidPath;
const tslib_1 = require("tslib");
const upath_1 = tslib_1.__importDefault(require("upath"));
const global_1 = require("../../config/global");
const error_messages_1 = require("../../constants/error-messages");
const logger_1 = require("../../logger");
function assertBaseDir(path, allowedDir) {
    if (!path.startsWith(allowedDir)) {
        logger_1.logger.debug({ path, allowedDir }, 'Preventing access to file outside allowed directory');
        throw new Error(error_messages_1.FILE_ACCESS_VIOLATION_ERROR);
    }
}
function ensurePath(path, key) {
    const baseDir = upath_1.default.resolve(global_1.GlobalConfig.get(key));
    const fullPath = upath_1.default.resolve(upath_1.default.isAbsolute(path) ? path : upath_1.default.join(baseDir, path));
    assertBaseDir(fullPath, baseDir);
    return fullPath;
}
function ensureLocalPath(path) {
    return ensurePath(path, 'localDir');
}
function ensureCachePath(path) {
    return ensurePath(path, 'cacheDir');
}
function isValidPath(path, key) {
    const baseDir = upath_1.default.resolve(global_1.GlobalConfig.get(key));
    const fullPath = upath_1.default.resolve(upath_1.default.isAbsolute(path) ? path : upath_1.default.join(baseDir, path));
    return fullPath.startsWith(baseDir);
}
//# sourceMappingURL=util.js.map