"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.filterMap = filterMap;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
/**
 * Filter and map an array *in place* with single iteration.
 */
function filterMap(array, fn) {
    const length = array.length;
    let newIdx = 0;
    for (let oldIdx = 0; oldIdx < length; oldIdx += 1) {
        const item = array[oldIdx];
        const res = fn(item);
        if (is_1.default.truthy(res)) {
            array[newIdx] = res;
            newIdx += 1;
        }
    }
    const deletedCount = length - newIdx;
    if (deletedCount) {
        array.length = length - deletedCount;
    }
    return array;
}
//# sourceMappingURL=filter-map.js.map