"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isHermit = isHermit;
exports.findHermitCwd = findHermitCwd;
exports.getHermitEnvs = getHermitEnvs;
const tslib_1 = require("tslib");
const upath_1 = tslib_1.__importDefault(require("upath"));
const global_1 = require("../../config/global");
const logger_1 = require("../../logger");
const fs_1 = require("../fs");
const regex_1 = require("../regex");
const common_1 = require("./common");
function isHermit() {
    return global_1.GlobalConfig.get('binarySource') === 'hermit';
}
async function findHermitCwd(cwd) {
    const relativeCwd = upath_1.default.relative(global_1.GlobalConfig.get('localDir', ''), cwd);
    const hermitFile = await (0, fs_1.findUpLocal)('bin/hermit', relativeCwd);
    if (hermitFile === null) {
        throw new Error(`hermit not found for ${cwd}`);
    }
    return upath_1.default.join(global_1.GlobalConfig.get('localDir'), upath_1.default.dirname(hermitFile));
}
async function getHermitEnvs(rawOptions) {
    const cwd = rawOptions.cwd ?? /* istanbul ignore next */ '';
    const hermitCwd = await findHermitCwd(cwd);
    logger_1.logger.debug({ cwd, hermitCwd }, 'fetching hermit environment variables');
    // with -r will output the raw unquoted environment variables to consume
    const hermitEnvResp = await (0, common_1.rawExec)('./hermit env -r', {
        ...rawOptions,
        cwd: hermitCwd,
    });
    const out = {};
    const lines = hermitEnvResp.stdout
        .split(regex_1.newlineRegex)
        .map((line) => line.trim())
        .filter((line) => line.includes('='));
    for (const line of lines) {
        const equalIndex = line.indexOf('=');
        const name = line.substring(0, equalIndex);
        out[name] = line.substring(equalIndex + 1);
    }
    return out;
}
//# sourceMappingURL=hermit.js.map