"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setCustomEnv = setCustomEnv;
exports.getCustomEnv = getCustomEnv;
exports.setUserEnv = setUserEnv;
exports.getUserEnv = getUserEnv;
exports.getEnv = getEnv;
const tslib_1 = require("tslib");
const memCache = tslib_1.__importStar(require("./cache/memory"));
let customEnv = {};
function setCustomEnv(envObj) {
    customEnv = envObj;
}
function getCustomEnv() {
    return customEnv;
}
function setUserEnv(envObj) {
    memCache.set('userEnv', envObj);
}
function getUserEnv() {
    return memCache.get('userEnv') ?? {};
}
/**
 * Combination of process.env, customEnvVariables and user configured env
 *
 * Precedence: userEnv > customEnvVariables > process.env
 */
function getEnv() {
    return {
        ...process.env,
        ...getCustomEnv(),
        ...getUserEnv(),
    };
}
//# sourceMappingURL=env.js.map