"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decorate = decorate;
/**
 * Applies decorating function to intercept decorated method calls.
 * @param fn - The decorating function.
 */
function decorate(fn) {
    const result = (target, key, descriptor = {
        enumerable: true,
        configurable: true,
        writable: true,
        ...Object.getOwnPropertyDescriptor(target, key),
    }) => {
        const { value } = descriptor;
        return Object.assign(descriptor, {
            value(...args) {
                return fn({
                    args,
                    instance: this,
                    callback: () => value?.apply(this, args),
                    methodName: value?.name,
                });
            },
        });
    };
    return result;
}
//# sourceMappingURL=index.js.map