"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getElapsedDays = getElapsedDays;
exports.getElapsedMinutes = getElapsedMinutes;
exports.getElapsedHours = getElapsedHours;
exports.getElapsedMs = getElapsedMs;
const luxon_1 = require("luxon");
const ONE_MINUTE_MS = 60 * 1000;
function getElapsedDays(timestamp) {
    const currentVersionTimestampDate = luxon_1.DateTime.fromISO(timestamp);
    const now = luxon_1.DateTime.now();
    const diffInDays = now.diff(currentVersionTimestampDate, 'days').as('days');
    const ageInDays = Math.floor(diffInDays);
    return ageInDays;
}
function getElapsedMinutes(date) {
    return Math.floor((new Date().getTime() - date.getTime()) / ONE_MINUTE_MS);
}
function getElapsedHours(date) {
    const pastDate = typeof date === 'string'
        ? luxon_1.DateTime.fromISO(date)
        : luxon_1.DateTime.fromJSDate(date);
    if (!pastDate.isValid) {
        return 0;
    }
    const diff = luxon_1.DateTime.now().diff(pastDate, 'hours');
    return Math.floor(diff.hours);
}
function getElapsedMs(timestamp) {
    return new Date().getTime() - new Date(timestamp).getTime();
}
//# sourceMappingURL=date.js.map