"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compressToBase64 = compressToBase64;
exports.decompressFromBase64 = decompressFromBase64;
const tslib_1 = require("tslib");
const node_util_1 = require("node:util");
const node_zlib_1 = tslib_1.__importStar(require("node:zlib"));
const brotliCompress = (0, node_util_1.promisify)(node_zlib_1.default.brotliCompress);
const brotliDecompress = (0, node_util_1.promisify)(node_zlib_1.default.brotliDecompress);
async function compressToBase64(input) {
    const buf = await brotliCompress(input, {
        params: {
            [node_zlib_1.constants.BROTLI_PARAM_MODE]: node_zlib_1.constants.BROTLI_MODE_TEXT,
            [node_zlib_1.constants.BROTLI_PARAM_QUALITY]: 8,
        },
    });
    return buf.toString('base64');
}
async function decompressFromBase64(input) {
    const buf = Buffer.from(input, 'base64');
    const str = await brotliDecompress(buf);
    return str.toString('utf8');
}
//# sourceMappingURL=compress.js.map