"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.clone = clone;
const json_1 = require("klona/json");
const logger_1 = require("../logger");
const stringify_1 = require("./stringify");
/**
 * Creates a deep clone of an object.
 * @param input The object to clone.
 */
function clone(input) {
    try {
        return (0, json_1.klona)(input);
    }
    catch (err) {
        logger_1.logger.warn({ err }, 'error cloning object');
        const str = (0, stringify_1.quickStringify)(input);
        if (str) {
            return JSON.parse(str);
        }
        // istanbul ignore next: not easily testable
        throw err;
    }
}
//# sourceMappingURL=clone.js.map