"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RepoCacheV13 = void 0;
const zod_1 = require("zod");
const schema_utils_1 = require("../../schema-utils");
exports.RepoCacheV13 = schema_utils_1.Json.pipe(zod_1.z
    .object({
    repository: zod_1.z.string().min(1),
    revision: zod_1.z.number().refine((v) => v === 13),
    payload: zod_1.z.string().min(1),
    hash: zod_1.z.string().min(1),
    fingerprint: zod_1.z.string().min(1),
})
    .strict());
//# sourceMappingURL=schema.js.map