"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initRepoCache = initRepoCache;
const cache_factory_1 = require("./impl/cache-factory");
const null_1 = require("./impl/null");
const _1 = require(".");
/**
 * Extracted to separate file in order to avoid circular module dependencies.
 */
async function initRepoCache(config) {
    (0, _1.resetCache)();
    const { repository, repositoryCache, repositoryCacheType: type = 'local', repoFingerprint, } = config;
    if (repositoryCache === 'disabled') {
        (0, _1.setCache)(new null_1.RepoCacheNull());
        return;
    }
    if (repositoryCache === 'enabled') {
        const cache = cache_factory_1.CacheFactory.get(repository, repoFingerprint, type);
        await cache.load();
        (0, _1.setCache)(cache);
        return;
    }
    if (repositoryCache === 'reset') {
        const cache = cache_factory_1.CacheFactory.get(repository, repoFingerprint, type);
        await cache.save();
        (0, _1.setCache)(cache);
        return;
    }
}
//# sourceMappingURL=init.js.map