"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CacheFactory = void 0;
const logger_1 = require("../../../../logger");
const local_1 = require("./local");
const s3_1 = require("./s3");
class CacheFactory {
    static get(repository, repoFingerprint, cacheType) {
        const type = cacheType.split('://')[0].trim().toLowerCase();
        switch (type) {
            case 'local':
                return new local_1.RepoCacheLocal(repository, repoFingerprint);
            case 's3':
                return new s3_1.RepoCacheS3(repository, repoFingerprint, cacheType);
            default:
                logger_1.logger.warn({ cacheType }, `Repository cache type not supported using type "local" instead`);
                return new local_1.RepoCacheLocal(repository, repoFingerprint);
        }
    }
}
exports.CacheFactory = CacheFactory;
//# sourceMappingURL=cache-factory.js.map