import type { RepoCacheRecord } from '../schema';
import type { RepoCache, RepoCacheData } from '../types';
export declare abstract class RepoCacheBase implements RepoCache {
    protected readonly repository: string;
    protected readonly fingerprint: string;
    protected platform: "azure" | "bitbucket" | "bitbucket-server" | "codecommit" | "gerrit" | "gitea" | "github" | "gitlab" | "local";
    private oldHash;
    private data;
    protected constructor(repository: string, fingerprint: string);
    protected abstract read(): Promise<string | null>;
    protected abstract write(data: RepoCacheRecord): Promise<void>;
    private static parseData;
    private restore;
    load(): Promise<void>;
    save(): Promise<void>;
    getData(): RepoCacheData;
    isModified(): boolean | undefined;
}
