"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTtlOverride = getTtlOverride;
exports.resolveTtlValues = resolveTtlValues;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const global_1 = require("../../../config/global");
const string_match_1 = require("../../string-match");
function getTtlOverride(namespace) {
    const overrides = global_1.GlobalConfig.get('cacheTtlOverride', {});
    let ttl = overrides[namespace];
    if (is_1.default.number(ttl)) {
        return ttl;
    }
    let maxLen = 0;
    for (const [key, value] of Object.entries(overrides)) {
        if (!is_1.default.number(value)) {
            continue;
        }
        const keyLen = key.length;
        if (keyLen > maxLen && (0, string_match_1.matchRegexOrGlob)(namespace, key)) {
            maxLen = keyLen;
            ttl = value;
        }
    }
    if (is_1.default.number(ttl)) {
        return ttl;
    }
    return undefined;
}
/**
 * Apply user-configured overrides and return the final values for soft/hard TTL.
 *
 * @param namespace Cache namespace
 * @param ttlMinutes TTL value configured in Renovate codebase
 * @returns
 */
function resolveTtlValues(namespace, ttlMinutes) {
    const softTtlMinutes = getTtlOverride(namespace) ?? ttlMinutes;
    const cacheHardTtlMinutes = global_1.GlobalConfig.get('cacheHardTtlMinutes', 7 * 24 * 60);
    const hardTtlMinutes = Math.max(softTtlMinutes, cacheHardTtlMinutes);
    return { softTtlMinutes, hardTtlMinutes };
}
//# sourceMappingURL=ttl.js.map