import type { PackageCacheNamespace } from './types';
export declare class SqlitePackageCache {
    private client;
    private readonly upsertStatement;
    private readonly getStatement;
    private readonly deleteExpiredRows;
    private readonly countStatement;
    static init(cacheDir: string): Promise<SqlitePackageCache>;
    private constructor();
    set(namespace: PackageCacheNamespace, key: string, value: unknown, ttlMinutes?: number): Promise<void>;
    get<T = unknown>(namespace: PackageCacheNamespace, key: string): Promise<T | undefined>;
    private cleanupExpired;
    cleanup(): Promise<void>;
}
