/**
 * Assigns non-nullish values from `right` to `left` for the given `keys`.
 */
export declare function assignKeys<Left extends Partial<Record<K, unknown>>, Right extends {
    [key in K]?: Left[key];
}, K extends keyof Right>(left: Left, right: Right, keys: K[]): Left;
