export interface VulnerabilityPackage {
    ecosystem: 'maven' | 'npm' | 'nuget' | 'pip' | 'rubygems' | 'rust' | 'composer' | 'go';
    name: string;
}
export interface SecurityVulnerability {
    first_patched_version?: {
        identifier: string;
    } | null;
    package: VulnerabilityPackage;
    vulnerable_version_range: string;
}
export interface SecurityAdvisory {
    description: string;
    identifiers: {
        type: string;
        value: string;
    }[];
    references?: {
        url: string;
    }[];
}
export interface VulnerabilityAlert {
    dismissed_reason?: string | null;
    security_advisory: SecurityAdvisory;
    security_vulnerability: SecurityVulnerability | null;
    dependency: {
        manifest_path: string;
    };
}
