"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.api = exports.supportsRanges = exports.urls = exports.displayName = exports.id = void 0;
const regex_1 = require("../../../util/regex");
const generic_1 = require("../generic");
exports.id = 'unity3d';
exports.displayName = 'Unity3D';
exports.urls = [
    'https://docs.unity3d.com/Manual/assembly-definition-includes.html#version-define-expressions',
];
exports.supportsRanges = false;
class Unity3dVersioningApi extends generic_1.GenericVersioningApi {
    static parsingRegex = (0, regex_1.regEx)(/^(?<major>\d+)\.(?<minor>\d+)\.(?<patch>\d+)(?<releaseStream>\w)(?<build>\d+)/);
    static ReleaseStreamType = [
        'a', // Alpha
        'b', // Beta
        'p', // Patch
        'x', // Experimental
        'f', // Stable
        'c', // Stable (China)
    ];
    static stableVersions = ['f', 'c'];
    _parse(version) {
        const matches = Unity3dVersioningApi.parsingRegex.exec(version);
        if (!matches?.groups) {
            return null;
        }
        const { major, minor, patch, releaseStream, build } = matches.groups;
        const release = [
            parseInt(major, 10),
            parseInt(minor, 10),
            parseInt(patch, 10),
            Unity3dVersioningApi.ReleaseStreamType.indexOf(releaseStream),
            parseInt(build, 10),
        ];
        const isStable = Unity3dVersioningApi.stableVersions.includes(releaseStream);
        return { release, prerelease: isStable ? undefined : build };
    }
}
exports.api = new Unity3dVersioningApi();
exports.default = exports.api;
//# sourceMappingURL=index.js.map