"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.api = exports.supportsRanges = exports.urls = exports.displayName = exports.id = void 0;
const regex_1 = require("../../../util/regex");
const generic_1 = require("../generic");
exports.id = 'unity3d-packages';
exports.displayName = 'Unity3D Packages';
exports.urls = [
    'https://docs.unity3d.com/Manual/upm-semver.html',
    'https://docs.unity3d.com/Manual/upm-lifecycle.html',
];
exports.supportsRanges = false;
class Unity3dPackagesVersioningApi extends generic_1.GenericVersioningApi {
    static parsingRegex = (0, regex_1.regEx)(/^(?<major>\d+)\.(?<minor>\d+)\.(?<patch>\d+)(-?(?<label>.*))/);
    static unstableRegex = (0, regex_1.regEx)(/^(exp.|pre.|preview.)/);
    _parse(version) {
        const matches = Unity3dPackagesVersioningApi.parsingRegex.exec(version);
        if (!matches?.groups) {
            return null;
        }
        const { major, minor, patch, label } = matches.groups;
        const release = [
            parseInt(major, 10),
            parseInt(minor, 10),
            parseInt(patch, 10),
        ];
        const isStable = !Unity3dPackagesVersioningApi.unstableRegex.test(label);
        return { release, prerelease: isStable ? undefined : label };
    }
}
exports.api = new Unity3dPackagesVersioningApi();
exports.default = exports.api;
//# sourceMappingURL=index.js.map