"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isDatedCodeName = isDatedCodeName;
exports.getDatedContainerImageCodename = getDatedContainerImageCodename;
exports.getDatedContainerImageVersion = getDatedContainerImageVersion;
exports.getDatedContainerImageSuffix = getDatedContainerImageSuffix;
const regex_1 = require("../../../util/regex");
const regex = (0, regex_1.regEx)(/^(?<codename>\w+)-(?<date>\d{8})(?<suffix>\.\d{1,2})?$/);
function isDatedCodeName(input) {
    return regex.test(input);
}
function getDatedContainerImageCodename(version) {
    const groups = regex.exec(version);
    if (!groups?.groups) {
        return null;
    }
    return groups.groups.codename;
}
function getDatedContainerImageVersion(version) {
    const groups = regex.exec(version);
    if (!groups?.groups) {
        return null;
    }
    return parseInt(groups.groups.date, 10);
}
function getDatedContainerImageSuffix(version) {
    const groups = regex.exec(version);
    if (!groups?.groups?.suffix) {
        return null;
    }
    return groups.groups.suffix;
}
//# sourceMappingURL=common.js.map