"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toSemverRange = toSemverRange;
exports.getNewValue = getNewValue;
const tslib_1 = require("tslib");
const semver_1 = tslib_1.__importDefault(require("semver"));
const regex_1 = require("../../../util/regex");
const fromParam = (0, regex_1.regEx)(/^\s*from\s*:\s*"([^"]+)"\s*$/);
const fromRange = (0, regex_1.regEx)(/^\s*"([^"]+)"\s*\.\.\.\s*$/);
const binaryRange = (0, regex_1.regEx)(/^\s*"([^"]+)"\s*(\.\.[.<])\s*"([^"]+)"\s*$/);
const toRange = (0, regex_1.regEx)(/^\s*(\.\.[.<])\s*"([^"]+)"\s*$/);
const vPrefix = (0, regex_1.regEx)(/^v([0-9]+)/);
function toSemverRange(range) {
    const fromParamMatch = fromParam.exec(range);
    if (fromParamMatch) {
        const [, version] = fromParamMatch;
        if (semver_1.default.valid(version)) {
            const nextMajor = `${semver_1.default.major(version) + 1}.0.0`;
            return `>=${version} <${nextMajor}`;
        }
        return null;
    }
    const fromRangeMatch = fromRange.exec(range);
    if (fromRangeMatch) {
        const [, version] = fromRangeMatch;
        if (semver_1.default.valid(version)) {
            return `>=${version}`;
        }
        return null;
    }
    const binaryRangeMatch = binaryRange.exec(range);
    if (binaryRangeMatch) {
        const [, currentVersion, op, newVersion] = binaryRangeMatch;
        if (semver_1.default.valid(currentVersion) && semver_1.default.valid(newVersion)) {
            return op === '..<'
                ? `>=${currentVersion} <${newVersion}`
                : `>=${currentVersion} <=${newVersion}`;
        }
        return null;
    }
    const toRangeMatch = toRange.exec(range);
    if (toRangeMatch) {
        const [, op, newVersion] = toRangeMatch;
        if (semver_1.default.valid(newVersion)) {
            return op === '..<' ? `<${newVersion}` : `<=${newVersion}`;
        }
    }
    return null;
}
function getNewValue({ currentValue, newVersion }) {
    // Remove the v prefix if it exists
    const cleanNewVersion = newVersion.replace(vPrefix, '$1');
    if (fromParam.test(currentValue)) {
        return currentValue.replace((0, regex_1.regEx)(/".*?"/), `"${cleanNewVersion}"`);
    }
    const fromRangeMatch = fromRange.exec(currentValue);
    if (fromRangeMatch) {
        const [, version] = fromRangeMatch;
        return currentValue.replace(version, cleanNewVersion);
    }
    const binaryRangeMatch = binaryRange.exec(currentValue);
    if (binaryRangeMatch) {
        const [, , , version] = binaryRangeMatch;
        return currentValue.replace(version, cleanNewVersion);
    }
    const toRangeMatch = toRange.exec(currentValue);
    if (toRangeMatch) {
        const [, , version] = toRangeMatch;
        return currentValue.replace(version, cleanNewVersion);
    }
    return cleanNewVersion;
}
//# sourceMappingURL=range.js.map