"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Versioning = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const zod_1 = require("zod");
const logger_1 = require("../../logger");
const api_1 = tslib_1.__importDefault(require("./api"));
const defaultVersioning = tslib_1.__importStar(require("./semver-coerced"));
exports.Versioning = zod_1.z
    .string()
    .transform((versioningSpec, ctx) => {
    const [versioningName, ...versioningRest] = versioningSpec.split(':');
    let versioning = api_1.default.get(versioningName);
    if (!versioning) {
        logger_1.logger.debug(`Versioning: '${versioningSpec}' not found, falling back to ${defaultVersioning.id}`);
        return defaultVersioning.api;
    }
    if (is_1.default.function(versioning)) {
        const versioningConfig = versioningRest.length
            ? versioningRest.join(':')
            : undefined;
        try {
            versioning = new versioning(versioningConfig);
        }
        catch (error) {
            ctx.addIssue({
                code: 'custom',
                message: `Versioning: '${versioningSpec}' failed to initialize`,
                params: { error },
            });
            return zod_1.z.NEVER;
        }
    }
    return versioning;
});
//# sourceMappingURL=schema.js.map