export interface Range {
    version: string;
    operator: string;
    delimiter: string;
    /**
     * If the range is `~>` and immediately followed by `>=`,
     * the latter range is considered the former's companion
     * and assigned here instead of being an independent range.
     *
     * Example: `'~> 6.2', '>= 6.2.1'`
     */
    companion?: Range;
}
declare const parse: (range: string) => Range;
/** Wrapper for {@link satisfies} for {@link Range} record. */
export declare function satisfiesRange(ver: string, range: Range): boolean;
/**
 * Parses a comma-delimited list of range parts,
 * with special treatment for a pair of `~>` and `>=` parts.
 */
export declare function parseRanges(range: string): Range[];
/**
 * Stringifies a list of range parts into a comma-separated string,
 * with special treatment for a pair of `~>` and `>=` parts.
 */
export declare function stringifyRanges(ranges: Range[]): string;
declare const ltr: (version: string, range: string) => boolean;
export { parse, ltr };
