"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseRange = parseRange;
const regex_1 = require("../../../util/regex");
// This range format was chosen because it is common in the ecosystem
const gteAndLtRange = (0, regex_1.regEx)(/>=(?<lower>[\d.]+)&&<(?<upper>[\d.]+)/);
const ltAndGteRange = (0, regex_1.regEx)(/<(?<upper>[\d.]+)&&>=(?<lower>[\d.]+)/);
function parseRange(input) {
    const noSpaces = input.replaceAll(' ', '');
    let m = gteAndLtRange.exec(noSpaces);
    if (!m?.groups) {
        m = ltAndGteRange.exec(noSpaces);
        if (!m?.groups) {
            return null;
        }
    }
    return {
        lower: m.groups.lower,
        upper: m.groups.upper,
    };
}
//# sourceMappingURL=range.js.map