"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findScheduleForCodename = findScheduleForCodename;
exports.findScheduleForVersion = findScheduleForVersion;
const tslib_1 = require("tslib");
const data_files_generated_1 = tslib_1.__importDefault(require("../../../data-files.generated"));
const semver_1 = tslib_1.__importDefault(require("../semver"));
const nodeSchedule = JSON.parse(data_files_generated_1.default.get('data/node-js-schedule.json'));
const nodeCodenames = new Map();
for (const version of Object.keys(nodeSchedule)) {
    const schedule = nodeSchedule[version];
    if (schedule.codename) {
        nodeCodenames.set(schedule.codename.toUpperCase(), {
            version,
            ...schedule,
        });
    }
}
function findScheduleForCodename(codename) {
    return nodeCodenames.get(codename?.toUpperCase()) ?? null;
}
function findScheduleForVersion(version) {
    const major = semver_1.default.getMajor(version);
    // TODO: types (#22198)
    const schedule = nodeSchedule[`v${major}`];
    return schedule;
}
//# sourceMappingURL=schedule.js.map