"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findLambdaScheduleForVersion = findLambdaScheduleForVersion;
const tslib_1 = require("tslib");
const data_files_generated_1 = tslib_1.__importDefault(require("../../../data-files.generated"));
const regex_1 = require("../../../util/regex");
const node_1 = require("../node");
const lambdaSchedule = JSON.parse(data_files_generated_1.default.get('data/lambda-node-js-schedule.json'));
function findLambdaScheduleForVersion(version) {
    const majorVersionMatch = (0, regex_1.regEx)(/^v?([0-9]+)\./).exec(version);
    if (!majorVersionMatch) {
        return null;
    }
    if (!(0, node_1.isStable)(version)) {
        return null;
    }
    return lambdaSchedule[majorVersionMatch[1]] ?? null;
}
//# sourceMappingURL=schedule.js.map