"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getVersionings = exports.getVersioningList = exports.defaultVersioning = void 0;
exports.get = get;
const tslib_1 = require("tslib");
const api_1 = tslib_1.__importDefault(require("./api"));
const schema_1 = require("./schema");
const semverCoerced = tslib_1.__importStar(require("./semver-coerced"));
tslib_1.__exportStar(require("./types"), exports);
exports.defaultVersioning = semverCoerced;
const getVersioningList = () => Array.from(api_1.default.keys());
exports.getVersioningList = getVersioningList;
/**
 * Get versioning map. Can be used to dynamically add new versioning type
 */
const getVersionings = () => api_1.default;
exports.getVersionings = getVersionings;
function get(versioning) {
    const res = schema_1.Versioning.safeParse(versioning ?? exports.defaultVersioning.id);
    if (!res.success) {
        const [issue] = res.error.issues;
        if (issue && issue.code === 'custom' && issue.params?.error) {
            throw issue.params.error;
        }
        // istanbul ignore next: should never happen
        throw res.error;
    }
    return res.data;
}
//# sourceMappingURL=index.js.map