import type { RegExpVersion } from '../regex';
import { RegExpVersioningApi } from '../regex';
import type { VersioningApiConstructor } from '../types';
export declare const id = "hermit";
export declare const displayName = "Hermit";
export declare const urls: string[];
export declare const supportsRanges = false;
export declare class HermitVersioning extends RegExpVersioningApi {
    static versionRegex: string;
    constructor();
    private _isValid;
    private _parseHermitVersioning;
    protected _parse(version: string): RegExpVersion | null;
    private static _isChannel;
    private static _getChannel;
    isStable(version: string): boolean;
    isValid(version: string): boolean;
    isLessThanRange(version: string, range: string): boolean;
    protected _compare(version: string, other: string): number;
    matches(version: string, range: string): boolean;
}
export declare const api: VersioningApiConstructor;
export default api;
