export declare const TokenType: {
    Number: number;
    String: number;
};
interface Token {
    type: number;
    val: string | number;
}
export declare function tokenize(versionStr: string): Token[] | null;
export declare const QualifierRank: {
    readonly Dev: -1;
    readonly Default: 0;
    readonly RC: 1;
    readonly Snapshot: 2;
    readonly Final: 3;
    readonly GA: 4;
    readonly Release: 5;
    readonly SP: 6;
};
export declare function qualifierRank(input: string): number;
export declare function compare(left: string, right: string): number;
export declare function parse(input: string): Token[] | null;
export declare function isVersion(input: string): boolean;
interface PrefixRange {
    tokens: Token[];
}
export type RangeBound = 'inclusive' | 'exclusive';
interface MavenBasedRange {
    leftBound: RangeBound;
    leftBoundStr: string;
    leftVal: string | null;
    separator: string;
    rightBound: RangeBound;
    rightBoundStr: string;
    rightVal: string | null;
}
export declare function parsePrefixRange(input: string): PrefixRange | null;
export declare function parseMavenBasedRange(input: string): MavenBasedRange | null;
interface SingleVersionRange {
    val: string;
}
export declare function parseSingleVersionRange(input: string): SingleVersionRange | null;
export declare function isValid(str: string): boolean;
export {};
