"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.api = exports.supportsRanges = exports.urls = exports.displayName = exports.id = void 0;
const regex_1 = require("../../../util/regex");
const generic_1 = require("../generic");
exports.id = 'devbox';
exports.displayName = 'devbox';
exports.urls = [];
exports.supportsRanges = false;
const validPattern = (0, regex_1.regEx)(/^((\d|[1-9]\d*)(\.(\d|[1-9]\d*)){0,2})$/);
const versionPattern = (0, regex_1.regEx)(/^((\d|[1-9]\d*)(\.(\d|[1-9]\d*)){2})$/);
class DevboxVersioningApi extends generic_1.GenericVersioningApi {
    _parse(version) {
        const matches = validPattern.exec(version);
        if (!matches) {
            return null;
        }
        const release = matches[0].split('.').map(Number);
        return { release };
    }
    isValid(version) {
        if (version === 'latest') {
            return true;
        }
        return this._parse(version) !== null;
    }
    isVersion(version) {
        if (version === 'latest') {
            return false;
        }
        const matches = versionPattern.exec(version);
        return !!matches;
    }
    matches(version, range) {
        return this.isVersion(version) && this.equals(version, range);
    }
    _compare(version, other) {
        const parsed1 = this._parse(version);
        const parsed2 = this._parse(other);
        // Treat "latest" as * and always return equal
        if (other === 'latest' && parsed1) {
            return 0;
        }
        // If either version is invalid, return unequal
        if (!(parsed1 && parsed2)) {
            return 1;
        }
        // support variable length compare
        const length = Math.max(parsed1.release.length, parsed2.release.length);
        for (let i = 0; i < length; i += 1) {
            // 2.1 and 2.1.0 are equivalent
            const part1 = parsed1.release[i];
            const part2 = parsed2.release[i];
            // if part1 or part2 is undefined, we should treat them as equal
            // e.g. 1.0.0 === 1.0
            if (part1 !== undefined && part2 !== undefined && part1 !== part2) {
                return part1 - part2;
            }
        }
        return 0;
    }
}
exports.api = new DevboxVersioningApi();
exports.default = exports.api;
//# sourceMappingURL=index.js.map