import type { GenericVersion } from '../generic';
import type { VersioningApi } from '../types';
export declare const id = "deb";
export declare const displayName = "Deb version";
export declare const urls: string[];
export declare const supportsRanges = false;
export interface DebVersion extends GenericVersion {
    /**
     * epoch, defaults to 0 if not present, are used to leave version mistakes and previous
     * versioning schemes behind.
     */
    epoch: number;
    /**
     * upstreamVersion is the main version part: it defines the version of origin software
     * that was packaged.
     */
    upstreamVersion: string;
    /**
     * debianRevision is used to distinguish between different versions of packaging for the
     * same upstream version.
     */
    debianRevision: string;
}
export declare const api: VersioningApi;
export default api;
