import type { SemVer } from 'semver';
import type { RangeStrategy } from '../../../types/versioning';
import type { NewValueConfig } from '../types';
export declare const id = "conda";
export declare const displayName = "conda";
export declare const urls: string[];
export declare const supportsRanges = true;
export declare const supportedRangeStrategies: RangeStrategy[];
declare function isValidVersion(s: string): boolean;
declare function isValid(input: string): boolean;
declare function matches(version: string, range: string): boolean;
declare function isSingleVersion(input: string): boolean;
declare function getNewValue({ currentValue, rangeStrategy, currentVersion, newVersion, isReplacement, }: NewValueConfig): string | null;
declare function sortVersions(version: string, other: string): number;
declare function equals(version: string, other: string): boolean;
declare function isStable(version: string): boolean;
declare function isCompatible(version: string, current?: string): boolean;
declare function getMajor(version: string | SemVer): null | number;
declare function getMinor(version: string | SemVer): null | number;
declare function getPatch(version: string | SemVer): null | number;
declare function isGreaterThan(version: string, other: string): boolean;
declare function getSatisfyingVersion(versions: string[], range: string): string | null;
declare function minSatisfyingVersion(versions: string[], range: string): string | null;
export declare const api: {
    equals: typeof equals;
    isValid: typeof isValid;
    isVersion: typeof isValidVersion;
    isSingleVersion: typeof isSingleVersion;
    isStable: typeof isStable;
    isCompatible: typeof isCompatible;
    getMajor: typeof getMajor;
    getMinor: typeof getMinor;
    getPatch: typeof getPatch;
    isGreaterThan: typeof isGreaterThan;
    getSatisfyingVersion: typeof getSatisfyingVersion;
    minSatisfyingVersion: typeof minSatisfyingVersion;
    getNewValue: typeof getNewValue;
    matches: typeof matches;
    sortVersions: typeof sortVersions;
};
export {};
